DROP TABLE MSP_NUMBER_FIELDS CASCADE CONSTRAINTS;
create table MSP_NUMBER_FIELDS (
PROJ_ID NUMBER(18,0), 
NUM_CATEGORY NUMBER(18,0), 
NUM_REF_UID NUMBER(18,0), 
 NUM_FIELD_ID NUMBER(18,0), 
NUM_VALUE FLOAT) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 


create unique index I_MSP_NUMBER_FIELDS on MSP_NUMBER_FIELDS (
PROJ_ID,
NUM_CATEGORY,
NUM_REF_UID,
NUM_FIELD_ID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 



DROP TABLE MSP_TEXT_FIELDS CASCADE CONSTRAINTS;
 create table MSP_TEXT_FIELDS (PROJ_ID NUMBER(18,0), 
TEXT_CATEGORY NUMBER(18,0), 
TEXT_REF_UID NUMBER(18,0), 
 TEXT_FIELD_ID NUMBER(18,0) , 
TEXT_VALUE VARCHAR2(255)) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_TEXT_FIELDS on MSP_TEXT_FIELDS (
PROJ_ID,
TEXT_CATEGORY,
TEXT_REF_UID,
TEXT_FIELD_ID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 



DROP TABLE MSP_DATE_FIELDS CASCADE CONSTRAINTS;
create table MSP_DATE_FIELDS (
PROJ_ID NUMBER(18,0), 
DATE_CATEGORY NUMBER(18,0), 
DATE_REF_UID NUMBER(18,0),  
DATE_FIELD_ID NUMBER(18,0), 
DATE_VALUE DATE) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_DATE_FIELDS on MSP_DATE_FIELDS (
PROJ_ID,
DATE_CATEGORY,
DATE_REF_UID,
DATE_FIELD_ID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 



DROP TABLE MSP_DURATION_FIELDS CASCADE CONSTRAINTS;
 create table MSP_DURATION_FIELDS (
PROJ_ID  NUMBER(18,0), 
DUR_CATEGORY NUMBER(18,0), 
DUR_REF_UID NUMBER(18,0),  
DUR_FIELD_ID NUMBER(18,0) , 
DUR_VALUE NUMBER(18,0), 
DUR_FMT NUMBER(6,0) ) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_DURATION_FIELDS on MSP_DURATION_FIELDS (PROJ_ID,
DUR_CATEGORY,DUR_REF_UID,DUR_FIELD_ID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 



DROP TABLE MSP_FLAG_FIELDS CASCADE CONSTRAINTS;
create table MSP_FLAG_FIELDS (
PROJ_ID NUMBER(18,0), 
FLAG_CATEGORY NUMBER(18,0), 
FLAG_REF_UID NUMBER(18,0),  
FLAG_FIELD_ID NUMBER(18,0), 
FLAG_VALUE NUMBER(2,0)) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_FLAG_FIELDS on MSP_FLAG_FIELDS (PROJ_ID,FLAG_CATEGORY,
FLAG_REF_UID,FLAG_FIELD_ID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 



DROP TABLE MSP_CODE_FIELDS CASCADE CONSTRAINTS;
create table MSP_CODE_FIELDS (
PROJ_ID NUMBER(18,0), 
CODE_CATEGORY NUMBER(18,0), 
CODE_REF_UID NUMBER(18,0),  
CODE_FIELD_ID NUMBER(18,0),
 CODE_UID NUMBER(18,0)) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_CODE_FIELDS on MSP_CODE_FIELDS (PROJ_ID,CODE_CATEGORY,
CODE_REF_UID,CODE_FIELD_ID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 



DROP TABLE MSP_TASK_BASELINES CASCADE CONSTRAINTS;

create table MSP_TASK_BASELINES (
PROJ_ID NUMBER(18,0),   
TASK_UID NUMBER(18,0),  
 TB_BASE_NUM NUMBER(6,0),   
TB_BASE_DUR NUMBER(18,0),   
TB_BASE_DUR_FMT NUMBER(6,0),   
TB_BASE_START DATE,    
TB_BASE_FINISH DATE,  
 TB_BASE_WORK FLOAT,    
TB_BASE_COST FLOAT)
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_TASK_BASELINES on MSP_TASK_BASELINES (PROJ_ID, TASK_UID
, TB_BASE_NUM)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 



DROP TABLE MSP_RESOURCE_BASELINES CASCADE CONSTRAINTS;
create table MSP_RESOURCE_BASELINES (
PROJ_ID NUMBER(18,0),   
RES_UID NUMBER(18,0),   
RB_BASE_NUM NUMBER(6,0),   
RB_BASE_WORK FLOAT,   
RB_BASE_COST FLOAT)
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_RESOURCE_BASELINES on MSP_RESOURCE_BASELINES (PROJ_ID, 
RES_UID, RB_BASE_NUM)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 



DROP TABLE MSP_ASSIGNMENT_BASELINES CASCADE CONSTRAINTS;
create table MSP_ASSIGNMENT_BASELINES (
PROJ_ID NUMBER(18,0),   
ASSN_UID NUMBER(18,0),   
AB_BASE_NUM NUMBER(6,0),  
 AB_BASE_START DATE,  
 AB_BASE_FINISH DATE,   
AB_BASE_WORK FLOAT,   
 AB_BASE_COST FLOAT,  
 AB_BASE_COST_PER_USE FLOAT, 
AB_REF_ENT_PROJ_ID NUMBER(18,0))
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_ASSIGNMENT_BASELINES on MSP_ASSIGNMENT_BASELINES (
PROJ_ID, ASSN_UID, AB_BASE_NUM)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 


DROP TABLE MSP_TASKS CASCADE CONSTRAINTS;

 create table MSP_TASKS (
 RESERVED_DATA char(1),
 PROJ_ID NUMBER(18,0)   ,
 TASK_ACWP FLOAT , 
TASK_BCWP FLOAT , 
TASK_BCWS FLOAT , 
TASK_DUR_VAR NUMBER(18,0) , 
TASK_FINISH_VAR NUMBER(18,0) , 
TASK_OUTLINE_NUM VARCHAR2  ( 255 ) , 
TASK_START_VAR NUMBER(18,0) , 
TASK_IS_OVERALLOCATED NUMBER(2,0) , 
TASK_OVT_WORK FLOAT , 
TASK_VAC FLOAT , 
TASK_REG_WORK FLOAT , 
TASK_NUM_OBJECTS NUMBER(18,0) , 
TASK_TOTAL_SLACK NUMBER(18,0) , 
EXT_EDIT_REF_DATA VARCHAR2  ( 255 ) , 
TASK_UID NUMBER(18,0) , 
TASK_ID NUMBER(18,0) , 
TASK_HAS_LINKED_FIELDS NUMBER(2,0) , 
TASK_IS_MILESTONE NUMBER(2,0) , 
TASK_IS_CRITICAL NUMBER(2,0) , 
TASK_IS_SUMMARY NUMBER(2,0) , 
TASK_IS_SUBPROJ NUMBER(2,0) , 
TASK_IS_MARKED NUMBER(2,0) , 
TASK_IGNORES_RES_CAL NUMBER(2,0) , 
TASK_IS_ROLLED_UP NUMBER(2,0) , 
TASK_IS_FROM_FINISH_SUBPROJ NUMBER(2,0) , 
TASK_BAR_IS_HIDDEN NUMBER(2,0) , 
TASK_IS_RECURRING NUMBER(2,0) , 
TASK_IS_RECURRING_SUMMARY NUMBER(2,0) , 
TASK_IS_EXTERNAL NUMBER(2,0) , 
TASK_IS_EFFORT_DRIVEN NUMBER(2,0) , 
TASK_IS_COLLAPSED NUMBER(2,0) , 
TASK_HAS_NOTES NUMBER(2,0) , 
TASK_IS_READONLY_SUBPROJ NUMBER(2,0) , 
TASK_LEVELING_CAN_SPLIT NUMBER(2,0) , 
TASK_LEVELING_ADJUSTS_ASSN NUMBER(2,0) , 
TASK_DUR_IS_EST NUMBER(2,0) , 
TASK_EARLY_FINISH DATE , 
TASK_LATE_START DATE , 
TASK_STOP_DATE DATE , 
TASK_RESUME_DATE DATE , 
TASK_FREE_SLACK NUMBER(18,0) , 
TASK_OUTLINE_LEVEL NUMBER(6,0) , 
TASK_DUR NUMBER(18,0) , 
TASK_DUR_FMT NUMBER(6,0) , 
TASK_ACT_DUR NUMBER(18,0) , 
TASK_REM_DUR NUMBER(18,0) , 
TASK_BASE_DUR NUMBER(18,0) , 
TASK_BASE_DUR_FMT NUMBER(6,0) , 
TASK_CONSTRAINT_TYPE NUMBER(6,0) , 
TASK_LEVELING_DELAY NUMBER(18,0) , 
TASK_LEVELING_DELAY_FMT NUMBER(6,0) ,
 TASK_START_DATE DATE , 
TASK_FINISH_DATE DATE , 
TASK_ACT_START DATE , 
TASK_ACT_FINISH DATE , 
TASK_BASE_START DATE ,
 TASK_BASE_FINISH DATE , 
TASK_CONSTRAINT_DATE DATE , 
TASK_PRIORITY NUMBER(6,0) , 
TASK_PCT_COMP NUMBER(6,0) , 
TASK_PCT_WORK_COMP NUMBER(6,0) , 
TASK_TYPE NUMBER(6,0) , 
TASK_FIXED_COST_ACCRUAL NUMBER(6,0) , 
TASK_CREATION_DATE DATE ,
 TASK_PRELEVELED_START DATE , 
TASK_PRELEVELED_FINISH DATE ,
 TASK_EARLY_START DATE , 
TASK_LATE_FINISH DATE , 
TASK_CAL_UID NUMBER(18,0) , 
TASK_DEADLINE DATE , 
TASK_WORK FLOAT , 
TASK_BASE_WORK FLOAT , 
TASK_ACT_WORK FLOAT , 
TASK_REM_WORK FLOAT , 
TASK_COST FLOAT , 
TASK_FIXED_COST FLOAT ,
 TASK_ACT_COST FLOAT ,
 TASK_REM_COST FLOAT , 
TASK_BASE_COST FLOAT , 
TASK_ACT_OVT_WORK FLOAT ,
 TASK_REM_OVT_WORK FLOAT ,
 TASK_OVT_COST FLOAT ,
 TASK_ACT_OVT_COST FLOAT ,
 TASK_REM_OVT_COST FLOAT ,
 TASK_WBS VARCHAR2  ( 255 ) ,
 TASK_NAME VARCHAR2  ( 255 ) , 
TASK_WBS_RIGHTMOST_LEVEL VARCHAR2  ( 255 ) , 
TASK_RTF_NOTES LONG RAW , 
TASK_EAC FLOAT ,
 TASK_PHY_PCT_COMP NUMBER(6,0) ,
 TASK_EVMETHOD NUMBER(6,0) ) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_TASKS on MSP_TASKS (PROJ_ID,TASK_UID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 


DROP TABLE MSP_TIMEPHASED_DATA CASCADE CONSTRAINTS;

 create table MSP_TIMEPHASED_DATA ( 
RESERVED_DATA char(1), 
PROJ_ID NUMBER(18,0)  
 , TD_UID NUMBER(18,0) , 
TD_FIELD_ID NUMBER(6,0) , 
TD_CATEGORY NUMBER(6,0) , 
TD_REF_UID NUMBER(18,0) , 
TD_START DATE ,
 TD_FINISH DATE , 
TD_UNITS NUMBER(6,0) , 
TD_VALUE1 FLOAT , 
TD_VALUE2 FLOAT , 
TD_VALUE3 FLOAT , 
TD_VALUE4 FLOAT , 
TD_VALUE5 FLOAT , 
TD_VALUE6 FLOAT , 
TD_VALUE7 FLOAT , 
TD_EXT_EDITED NUMBER(2,0) ) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 





create unique index I_MSP_TIMEPHASED_DATA on MSP_TIMEPHASED_DATA (PROJ_ID,TD_UID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 



DROP TABLE MSP_RESOURCES CASCADE CONSTRAINTS;


 create table MSP_RESOURCES ( 
RESERVED_DATA char(1), 
PROJ_ID NUMBER(18,0)   ,
 RES_ACWP FLOAT , 
RES_BCWP FLOAT , 
RES_BCWS FLOAT , 
RES_NUM_OBJECTS NUMBER(18,0) , 
EXT_EDIT_REF_DATA VARCHAR2  ( 255 ) , 
RES_UID NUMBER(18,0) , 
RES_ID NUMBER(18,0) ,
 RES_HAS_LINKED_FIELDS NUMBER(2,0) ,
 RES_IS_OVERALLOCATED NUMBER(2,0) , 
RES_TYPE NUMBER(2,0) , 
RES_HAS_NOTES NUMBER(2,0) , 
RES_CAN_LEVEL NUMBER(2,0) , 
RES_STD_RATE_FMT NUMBER(6,0) , 
RES_OVT_RATE_FMT NUMBER(6,0) , 
RES_ACCRUE_AT NUMBER(6,0) ,
 RES_WORKGROUP_MESSAGING NUMBER(6,0) , 
RES_CAL_UID NUMBER(18,0) , 
RES_AVAIL_FROM DATE , 
RES_AVAIL_TO DATE ,
 RES_STD_RATE FLOAT , 
RES_OVT_RATE FLOAT , 
RES_MAX_UNITS FLOAT , 
RES_WORK FLOAT ,
 RES_ACT_WORK FLOAT ,
 RES_BASE_WORK FLOAT ,
 RES_OVT_WORK FLOAT , 
RES_COST_PER_USE FLOAT ,
 RES_REM_WORK FLOAT , 
RES_REG_WORK FLOAT , 
RES_ACT_OVT_WORK FLOAT ,
 RES_REM_OVT_WORK FLOAT , 
RES_PEAK FLOAT , 
RES_ACT_COST FLOAT , 
RES_COST FLOAT , 
RES_BASE_COST FLOAT , 
RES_REM_COST FLOAT , 
RES_OVT_COST FLOAT , 
RES_ACT_OVT_COST FLOAT ,
 RES_REM_OVT_COST FLOAT , 
RES_NAME VARCHAR2  ( 255 ) ,
 RES_INITIALS VARCHAR2  ( 255 ) , 
RES_PHONETICS VARCHAR2  ( 255 ) ,
 RES_MATERIAL_LABEL VARCHAR2  ( 255 ) , 
RES_RTF_NOTES LONG RAW ,
RES_CHECKEDOUT NUMBER(18,0),
RES_CHECKOUTBY varchar2 (255),
RES_CHECKOUTDATE date,
 RES_ENTERPRISE_TIMESTAMP DATE , 
RES_EUID NUMBER(18,0) , 
RES_RTYPE NUMBER(6,0) ) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 





create unique index I_MSP_RESOURCES on MSP_RESOURCES (PROJ_ID,RES_UID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 


DROP TABLE MSP_RESOURCE_RATES CASCADE CONSTRAINTS;

 create table MSP_RESOURCE_RATES (
 RESERVED_DATA char(1),
 PROJ_ID NUMBER(18,0)   
, RR_UID NUMBER(18,0) ,
 RES_UID NUMBER(18,0) ,
 RR_RATE_TABLE NUMBER(6,0) , 
RR_FROM_DATE DATE , 
RR_TO_DATE DATE , 
RR_STD_RATE FLOAT ,
 RR_STD_RATE_FMT NUMBER(6,0) , 
RR_OVT_RATE FLOAT ,
 RR_OVT_RATE_FMT NUMBER(6,0) , 
RR_PER_USE_COST FLOAT ) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_RESOURCE_RATES on MSP_RESOURCE_RATES (PROJ_ID,RR_UID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 

DROP TABLE MSP_AVAILABILITY CASCADE CONSTRAINTS;


 create table MSP_AVAILABILITY ( 
RESERVED_DATA char(1), 
PROJ_ID NUMBER(18,0)   , 
AVAIL_UID NUMBER(18,0) ,
 RES_UID NUMBER(18,0) ,
 AVAIL_FROM DATE , 
AVAIL_TO DATE , 
AVAIL_UNITS FLOAT ) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_AVAILABILITY on MSP_AVAILABILITY (PROJ_ID,AVAIL_UID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 


DROP TABLE MSP_CALENDARS CASCADE CONSTRAINTS;

 create table MSP_CALENDARS ( 
RESERVED_DATA char(1),
 PROJ_ID NUMBER(18,0)   , 
CAL_UID NUMBER(18,0) ,
 CAL_BASE_UID NUMBER(18,0) ,
 RES_UID NUMBER(18,0) ,
 CAL_IS_BASE_CAL NUMBER(2,0) , 
CAL_NAME VARCHAR2  ( 255 ) ,
 CAL_ENTUID NUMBER(18,0) ) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_CALENDARS on MSP_CALENDARS (PROJ_ID,CAL_UID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 


DROP TABLE MSP_CALENDAR_DATA CASCADE CONSTRAINTS;

 create table MSP_CALENDAR_DATA ( 
RESERVED_DATA char(1), 
PROJ_ID NUMBER(18,0)   ,
 CD_UID NUMBER(18,0) ,
 CAL_UID NUMBER(18,0) , 
CD_DAY_OR_EXCEPTION NUMBER(6,0) , 
CD_WORKING NUMBER(6,0) ,
 CD_FROM_DATE DATE , 
CD_TO_DATE DATE , 
CD_FROM_TIME1 DATE , 
CD_TO_TIME1 DATE ,
 CD_FROM_TIME2 DATE , 
CD_TO_TIME2 DATE ,
 CD_FROM_TIME3 DATE ,
 CD_TO_TIME3 DATE , 
CD_FROM_TIME4 DATE , 
CD_TO_TIME4 DATE , 
CD_FROM_TIME5 DATE , 
CD_TO_TIME5 DATE ) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 





create unique index I_MSP_CALENDAR_DATA on MSP_CALENDAR_DATA (PROJ_ID,CD_UID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 


DROP TABLE MSP_FIELD_ATTRIBUTES CASCADE CONSTRAINTS;

 create table MSP_FIELD_ATTRIBUTES ( 
RESERVED_DATA char(1),
 PROJ_ID NUMBER(18,0) 
  , ATTRIB_FIELD_ID NUMBER(18,0) ,
 ATTRIB_ID NUMBER(18,0) , 
ATTRIB_VALUE NUMBER(18,0) ,
 AS_ID NUMBER(18,0) , 
ATTRIB_EXT_EDITED NUMBER(2,0) ) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_FIELD_ATTRIBUTES on MSP_FIELD_ATTRIBUTES (PROJ_ID,
ATTRIB_FIELD_ID,ATTRIB_ID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 



DROP TABLE MSP_ATTRIBUTE_STRINGS CASCADE CONSTRAINTS;

 create table MSP_ATTRIBUTE_STRINGS (
 RESERVED_DATA char(1),
 PROJ_ID NUMBER(18,0), 
AS_ID NUMBER(18,0) ,
 AS_POSITION NUMBER(18,0) , 
AS_VALUE VARCHAR2  ( 255 ) ) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_ATTRIBUTE_STRINGS on MSP_ATTRIBUTE_STRINGS (PROJ_ID,
AS_ID,AS_POSITION)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 


DROP TABLE MSP_ASSIGNMENTS CASCADE CONSTRAINTS;

 create table MSP_ASSIGNMENTS (
 RESERVED_DATA char(1), 
PROJ_ID NUMBER(18,0)   , 
ASSN_ACT_FINISH DATE , 
ASSN_ACT_START DATE ,
 ASSN_ACWP FLOAT , 
ASSN_BCWP FLOAT ,
 ASSN_BCWS FLOAT , 
ASSN_RES_TYPE NUMBER(2,0) , 
ASSN_IS_OVERALLOCATED NUMBER(2,0) ,
 ASSN_WORK_CONTOUR NUMBER(6,0) , 
ASSN_START_VAR NUMBER(18,0) ,
 ASSN_FINISH_VAR NUMBER(18,0) ,
 ASSN_UPDATE_NEEDED NUMBER(2,0) ,
 EXT_EDIT_REF_DATA VARCHAR2  ( 255 ) , 
ASSN_UID NUMBER(18,0) , 
ASSN_HAS_LINKED_FIELDS NUMBER(2,0) ,
 ASSN_IS_CONFIRMED NUMBER(2,0) , 
ASSN_RESPONSE_PENDING NUMBER(2,0) , 
ASSN_HAS_NOTES NUMBER(2,0) , 
ASSN_TEAM_STATUS_PENDING NUMBER(2,0) , 
TASK_UID NUMBER(18,0) , 
RES_UID NUMBER(18,0) , 
ASSN_START_DATE DATE , 
ASSN_FINISH_DATE DATE , 
ASSN_DELAY NUMBER(18,0) , 
ASSN_DELAY_FMT NUMBER(6,0) ,
 ASSN_LEVELING_DELAY NUMBER(18,0) , 
ASSN_COST_RATE_TABLE NUMBER(6,0) , 
ASSN_BASE_START DATE , 
ASSN_BASE_FINISH DATE ,
 ASSN_MATERIAL_RATE_FMT NUMBER(6,0) , 
ASSN_UNITS FLOAT , 
ASSN_WORK FLOAT ,
 ASSN_ACT_WORK FLOAT , 
ASSN_REG_WORK FLOAT , 
ASSN_REM_WORK FLOAT , 
ASSN_BASE_WORK FLOAT ,
 ASSN_COST FLOAT , 
ASSN_ACT_COST FLOAT ,
 ASSN_REM_COST FLOAT , 
ASSN_BASE_COST FLOAT , 
ASSN_BASE_COST_PER_USE FLOAT ,
 ASSN_OVT_WORK FLOAT , 
ASSN_ACT_OVT_WORK FLOAT , 
ASSN_REM_OVT_WORK FLOAT , 
ASSN_ACT_OVT_COST FLOAT , 
ASSN_REM_OVT_COST FLOAT ,
 ASSN_RTF_NOTES LONG RAW ,
 ASSN_ENTSUMPROJID NUMBER(18,0) ) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_ASSIGNMENTS on MSP_ASSIGNMENTS (PROJ_ID,ASSN_UID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 


DROP TABLE MSP_ASSN_ENTERPRISE CASCADE CONSTRAINTS;

 create table MSP_ASSN_ENTERPRISE ( 
RESERVED_DATA char(1), 
PROJ_ID NUMBER(18,0)  
 , ASSN_ACT_FINISH DATE , 
ASSN_ACT_START DATE ,
 ASSN_ACWP FLOAT , 
ASSN_BCWP FLOAT ,
 ASSN_BCWS FLOAT , 
ASSN_RES_TYPE NUMBER(2,0) , 
ASSN_IS_OVERALLOCATED NUMBER(2,0) ,
 ASSN_WORK_CONTOUR NUMBER(6,0) ,
 ASSN_START_VAR NUMBER(18,0) , 
ASSN_FINISH_VAR NUMBER(18,0) , 
ASSN_UPDATE_NEEDED NUMBER(2,0) , 
EXT_EDIT_REF_DATA VARCHAR2  ( 255 ) ,
 ASSN_UID NUMBER(18,0) , 
ASSN_HAS_LINKED_FIELDS NUMBER(2,0) , 
ASSN_IS_CONFIRMED NUMBER(2,0) , 
ASSN_RESPONSE_PENDING NUMBER(2,0) ,
 ASSN_HAS_NOTES NUMBER(2,0) , 
ASSN_TEAM_STATUS_PENDING NUMBER(2,0) , 
TASK_UID NUMBER(18,0) , 
RES_UID NUMBER(18,0) , 
ASSN_START_DATE DATE ,
 ASSN_FINISH_DATE DATE , 
ASSN_DELAY NUMBER(18,0) , 
ASSN_DELAY_FMT NUMBER(6,0) , 
ASSN_LEVELING_DELAY NUMBER(18,0) , 
ASSN_COST_RATE_TABLE NUMBER(6,0) , 
ASSN_BASE_START DATE , 
ASSN_BASE_FINISH DATE , 
ASSN_MATERIAL_RATE_FMT NUMBER(6,0) , 
ASSN_UNITS FLOAT ,
 ASSN_WORK FLOAT ,
 ASSN_ACT_WORK FLOAT ,
 ASSN_REG_WORK FLOAT , 
ASSN_REM_WORK FLOAT ,
 ASSN_BASE_WORK FLOAT , 
ASSN_COST FLOAT , 
ASSN_ACT_COST FLOAT , 
ASSN_REM_COST FLOAT , 
ASSN_BASE_COST FLOAT , 
ASSN_BASE_COST_PER_USE FLOAT , 
ASSN_OVT_WORK FLOAT , 
ASSN_ACT_OVT_WORK FLOAT , 
ASSN_REM_OVT_WORK FLOAT , 
ASSN_ACT_OVT_COST FLOAT , 
ASSN_REM_OVT_COST FLOAT , 
ASSN_RTF_NOTES LONG RAW , 
ASSN_ENTSUMPROJID NUMBER(18,0) ) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_ASSN_ENTERPRISE on MSP_ASSN_ENTERPRISE (PROJ_ID,
ASSN_UID,ASSN_ENTSUMPROJID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 


DROP TABLE MSP_LINKS CASCADE CONSTRAINTS;

 create table MSP_LINKS (
 RESERVED_DATA char(1),
 PROJ_ID NUMBER(18,0)   ,
 EXT_EDIT_REF_DATA VARCHAR2  ( 255 ) ,
 LINK_UID NUMBER(18,0) , 
LINK_IS_CROSS_PROJ NUMBER(2,0) , 
LINK_PRED_UID NUMBER(18,0) ,
 LINK_SUCC_UID NUMBER(18,0) , 
LINK_TYPE NUMBER(6,0) , 
LINK_LAG_FMT NUMBER(6,0) ,
 LINK_LAG NUMBER(18,0) ) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_LINKS on MSP_LINKS (PROJ_ID,LINK_UID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 


DROP TABLE MSP_OUTLINE_CODES CASCADE CONSTRAINTS;

 create table MSP_OUTLINE_CODES ( 
RESERVED_DATA char(1), 
PROJ_ID NUMBER(18,0)   ,
 CODE_UID NUMBER(18,0) , 
OC_PARENT NUMBER(18,0) , 
OC_FIELD_ID NUMBER(18,0) , 
OC_NAME VARCHAR2  ( 255 ) , 
OC_DESCRIPTION VARCHAR2  ( 255 ) , 
OC_CACHED_FULL_NAME VARCHAR2  ( 255 ) , 
OC_CACHED_IS_VALID NUMBER(2,0) ) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_OUTLINE_CODES on MSP_OUTLINE_CODES (PROJ_ID,CODE_UID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 


DROP TABLE MSP_STRING_TYPES CASCADE CONSTRAINTS;

create table MSP_STRING_TYPES (
STRING_TYPE_ID NUMBER(18,0), 
STRING_LANG_ID NUMBER(18,0),
 STRING_TYPE VARCHAR2(200))
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 52K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 




create unique index I_MSP_STRING_TYPES on MSP_STRING_TYPES (STRING_TYPE_ID,
STRING_LANG_ID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 



DROP TABLE MSP_PROJECTS CASCADE CONSTRAINTS;
CREATE TABLE MSP_PROJECTS (
	PROJ_ID NUMBER(18) ,
	PROJ_NAME VARCHAR2 (255)  ,
	PROJ_PROP_AUTHOR VARCHAR2 (255)  ,
	PROJ_OPT_CALC_ACT_COSTS NUMBER(2)   ,
	PROJ_PROP_CATEGORY VARCHAR2 (255)  ,
	PROJ_PROP_COMPANY VARCHAR2 (255)  ,
	PROJ_OPT_CRITICAL_SLACK_LIMIT NUMBER(18) ,
	PROJ_OPT_CURRENCY_DIGITS NUMBER(6) ,
	PROJ_OPT_CURRENCY_POSITION NUMBER(6) ,
	PROJ_OPT_CURRENCY_SYMBOL VARCHAR2 (20)  ,
	PROJ_OPT_NEW_ARE_EFFORT_DRIVEN NUMBER(2)   ,
	PROJ_INFO_CURRENT_DATE DATE  ,
	PROJ_OPT_DEF_FINISH_TIME DATE  ,
	PROJ_OPT_DEF_FIX_COST_ACCRUAL NUMBER(6) ,
	PROJ_OPT_MINUTES_PER_DAY NUMBER(18) ,
	PROJ_OPT_MINUTES_PER_WEEK NUMBER(18) ,
	PROJ_OPT_DEF_OVT_RATE FLOAT  ,
	PROJ_OPT_DEF_STD_RATE FLOAT  ,
	PROJ_OPT_DEF_START_TIME DATE  ,
	PROJ_OPT_DEF_TASK_TYPE NUMBER(6) ,
	PROJ_OPT_DUR_ENTRY_FMT NUMBER(6) ,
	PROJ_INFO_FINISH_DATE DATE  ,
	PROJ_OPT_HONOR_CONSTRAINTS NUMBER(2)   ,
	PROJ_PROP_KEYWORDS VARCHAR2 (255)  ,
	PROJ_LAST_SAVED DATE  ,
	PROJ_PROP_MANAGER VARCHAR2 (255)  ,
	PROJ_OPT_MULT_CRITICAL_PATHS NUMBER(2)   ,
	PROJ_CREATION_DATE DATE  ,
	PROJ_POOL_ATTACHED_TO VARCHAR2 (255)  ,
	PROJ_INFO_CAL_NAME VARCHAR2 (255)  ,
	PROJ_IS_RES_POOL NUMBER(2)   ,
	PROJ_INFO_SCHED_FROM NUMBER(6) ,
	PROJ_OPT_SPLIT_IN_PROGRESS NUMBER(2)   ,
	PROJ_OPT_SPREAD_ACT_COSTS NUMBER(2)   ,
	PROJ_OPT_SPREAD_PCT_COMP NUMBER(2)   ,
	PROJ_INFO_START_DATE DATE  ,
	PROJ_INFO_STATUS_DATE DATE  ,
	PROJ_PROP_SUBJECT VARCHAR2 (255)  ,
	PROJ_PROP_TITLE VARCHAR2 (255)  ,
	PROJ_OPT_TASK_UPDATES_RES NUMBER(2)   ,
	PROJ_OPT_WORK_ENTRY_FMT NUMBER(6) ,
	PROJ_OPT_CALC_SUB_AS_SUMMARY NUMBER(2)   ,
	PROJ_OPT_WEEK_START_DAY NUMBER(6) ,
	PROJ_OPT_FY_START_MONTH NUMBER(6) ,
	PROJ_OPT_FY_USE_START_YR NUMBER(2)   ,
	PROJ_OPT_DAYS_PER_MONTH NUMBER(6) ,
	PROJ_OPT_NEW_TASK_EST NUMBER(2)   ,
	PROJ_OPT_SHOW_EST_DUR NUMBER(2)   ,
	PROJ_OPT_EXPAND_TIMEPHASED NUMBER(2)   ,
	PROJ_EXT_EDITED_DATE NUMBER(2)   ,
	PROJ_EXT_EDITED_DUR NUMBER(2)   ,
	PROJ_EXT_EDITED_NUM NUMBER(2)   ,
	PROJ_EXT_EDITED_FLAG NUMBER(2)   ,
	PROJ_EXT_EDITED_CODE NUMBER(2)   ,
	PROJ_EXT_EDITED_TEXT NUMBER(2)   ,
	PROJ_EXT_EDITED NUMBER(2)   ,
	PROJ_DATA_SOURCE VARCHAR2 (128)  ,
	PROJ_READ_ONLY VARCHAR2 (10)  ,
	PROJ_READ_WRITE VARCHAR2 (4)  ,
	PROJ_READ_COUNT VARCHAR2 (10)  ,
	PROJ_LOCKED VARCHAR2 (4)  ,
	PROJ_MACHINE_ID VARCHAR2 (100)  ,
	RESERVED_BINARY_DATA LONG RAW,
	PROJ_TYPE NUMBER(18)  ,
	PROJ_CHECKEDOUT	NUMBER(18)  ,
	PROJ_CHECKOUTBY VARCHAR2(255), -- should eventually be set to NOT 
	PROJ_CHECKOUTDATE DATE, -- should eventually be set to NOT 
	PROJ_PROJECT VARCHAR2(203) ,
	PROJ_VERSION VARCHAR2(50) 
) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 1784K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 

CREATE UNIQUE INDEX I_MSP_PROJECTS ON MSP_PROJECTS(PROJ_ID) 
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 



DROP TABLE MSP_RES_GLOBAL_BINARY CASCADE CONSTRAINTS;

CREATE TABLE MSP_RES_GLOBAL_BINARY
( 
	PROJ_ID Number(18),
	GLB_CATEGORY Number(18),
	GLB_REF_UID Number(18),
	GLB_REF_ENT_PROJ_ID Number(18),
	GLB_BINARY_DATA Long Raw
) 
 TABLESPACE PROJECT_DATA
   PCTFREE 10   PCTUSED 40
   INITRANS 1   MAXTRANS 255
 STORAGE ( 
   INITIAL 52K NEXT 1784K PCTINCREASE 10
   MINEXTENTS 1 MAXEXTENTS 249 )
   NOCACHE; 

CREATE UNIQUE INDEX I_MSP_RES_GLOBA
ON MSP_RES_GLOBAL_BINARY (PROJ_ID, GLB_CATEGORY, GLB_REF_UID, GLB_REF_ENT_PROJ_ID)
  TABLESPACE PROJECT_DATA PCTFREE 10
  STORAGE(INITIAL 52K NEXT 52K PCTINCREASE 10 ) ; 
